import os
import json
import numpy as np

def mean_std(arr):
    return np.mean(arr), np.std(arr)

def process_json_files(directory_path):
    for filename in os.listdir(directory_path):
        if filename.endswith(".json"):
            file_path = os.path.join(directory_path, filename)
            try:
                with open(file_path, 'r') as f:
                    data = json.load(f)

                response_ratios = []
                hallucination_scores = []
                # utility_scores = []

                for item in data:
                    for prompt, value in item.items():  # one key-value per dict
                        scores = value.get("scores", {})
                        response_ratios.append(scores.get("response_ratio", 0.0))
                        hallucination_scores.append(scores.get("hallucination_score", 0.0))
                        # utility_scores.append(scores.get("utility_score", 0.0))

                rr_mean, rr_std = mean_std(response_ratios)
                hs_mean, hs_std = mean_std(hallucination_scores)
                # us_mean, us_std = mean_std(utility_scores)

                print(f"\nFile: {filename}")
                print(f"  Response Ratio        : {rr_mean:.4f} ± {rr_std:.4f}")
                print(f"  Hallucination Score   : {hs_mean:.4f} ± {hs_std:.4f}")

            except Exception as e:
                print(f"Error processing {filename}: {e}")


if __name__ == "__main__":
    process_json_files("he")